/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jdt.internal.corext.codemanipulation;

import org.eclipse.jdt.core.IMember;


/**
 * Query object to let operations callback the actions.
 * Example is a callback to ask if a existing method should be replaced.
 */
public interface IRequestQuery {

	// return codes
	int CANCEL= 0;
	int NO= 1;
	int YES= 2;
	int YES_ALL= 3;

	/**
	 * Do the callback. Returns YES, NO, YES_ALL or CANCEL
	 */
	int doQuery(IMember member);
}
